import numpy as np
import matplotlib.pyplot as pl
plt.rc('font', **{'size':15})

colfresneldarkblue   = np.array([44,46,131])/255
colfresnelmiddleblue = np.array([34,124,192])/255
colfresnellightblue  = np.array([0,165,226])/255
colfresnelgrey       = np.array([111,111,110])/255
colfresnelorange     = np.array([234,106,7])/255
colfresnelpurple     = np.array([113,55,140])/255
colfresnelgreen      = np.array([149,193,30])/255

x = np.linspace(0., 4*np.pi,100)
cosinus = np.cos(x)
sinus = np.sin(x)
plt.plot(x, cosinus, color = colfresnelorange    , linewidth=3.0, linestyle="-" , label="cos")
plt.plot(x, sinus  , color = colfresnelmiddleblue, linewidth=3.0, linestyle="--", label="sin")
plt.xlim(0, 4*np.pi)
plt.ylim(-1.2, 1.2)
plt.xlabel("x")
plt.ylabel("y")
plt.legend(loc='best')
plt.title("sin/cos between 0 and $4\pi$")
plt.savefig('simple_figure.pdf', bbox_inches='tight', pad_inches=0)
